﻿using System.ComponentModel;
using System.Collections.Generic;
using System.Diagnostics;
using Soneta.CRM;
using Soneta.Tools;
using Soneta.Core;
using Soneta.Types;
using Soneta.Business;
using Soneta.Ksiega;
using Soneta.Kasa;
using Soneta.Waluty;
using Soneta.Kasa.Forms;
using System;
using System.Collections;
using Soneta.Web;
using System.Web.UI.WebControls;

namespace ASP
{
    public partial class StrukturaWiekowaKontrahenci : System.Web.UI.Page
    {
        //
        // KONFIGURACJA RAPORTU
        //

        // 
        // - nazwa cechy kontrahenta        
        // - nazwa słownika 
        // - etykieta wyświetlana podczas pytania o wartość pola
        // 

        private const String wgWartościCechy = "Kategoria";
        private const String wgWartościDictionary = "F.Kategoria";
        private const String wgWartościLabel = "Kategoria";

        //
        // Czy pokazywać kolumnę "Razem przeterminowane.
        // Przy większej ilości kolumn może to oznaczać znaczne zmniejszenie szerokości
        //
        private const Boolean razemPrzeterminowane = false;

        //
        // Podział na strefy
        // W przypadku modyfikacji w tablicy okresy należy wpisać kolejne wartości graniczne	
        //
        private static readonly int[] okresy = new int[] { 30, 60, 90, 180, 365 };

        public static string Str_WeryfikatorWaluty = "Podaj walutę jeśli zestawienie nie jest robione wg wartości PLNHist.";
        public string Str_PrzeterminowaneOd1Do = "Przeterminowane~Od 1 do ";
        public string Str_PrzeterminowanePonad = "Przeterminowane~Ponad ";
        public string Str_PrzeterminowaneOd = "Przeterminowane~Od ";
        public string Str_Do = " do ";
        public string Str_Dni = " dni";
        public string Str_Kasowych = "kasowych";
        public string Str_Ksiegowych = "księgowych";
        public string Str_PerSaldo = "per saldo";
        public string Str_Naleznosci = "należności";
        public string Str_Zobowiazan = "zobowiązań";
        public string Str_Rodzaj = "Rodzaj";
        public string Str_Zakres = "Zakres";
        //
        // PARAMETERS
        //

        public enum Zakres
        { Razem, Kontrahenci, Pracownicy, Urzędy }

        public enum TypDokumentow
        { Zobowiązania, Należności, PerSaldo }

        public enum TypRozliczen
        {
            [Caption("wg rozrachunków")]
            Kasowe,
            [Caption("wg kont")]
            Księgowe
        }


        public class PrnParams : Soneta.Business.OkresContext
        {
            private FromTo okresKS;
            private Zakres zakres = Zakres.Kontrahenci;
            private TypRozliczen typRozliczen = TypRozliczen.Kasowe;
            private IPodmiotKasowy odk;
            private IPodmiotKasowy dok;
            private String wartośćCechy = String.Empty;
            private TypDokumentow dokumenty = TypDokumentow.Należności;
            private RodzajDokumentów rodzaj = RodzajDokumentów.Razem;
            private Boolean wgWartosciPLNHist;
            private Waluta waluta;
            private String aktualneKonto = String.Empty;


            public PrnParams(Context context)
                : base(context)
            {
                this.waluta = WalutyModule.GetInstance(this).Waluty.PLN;
                this.Okres = FromTo.All;
                this.okresKS = FromTo.All;
            }


            protected override void Accept()
            {
                Session.Verifiers.Add(new WeryfikatorWaluty(this));
                base.Accept();
            }


            [Priority(10)]
            public override Date Aktualny
            {
                get { return base.Aktualny; }
                set { base.Aktualny = value; }
            }


            [Priority(15)]
            [Caption("Typ rozliczeń")]
            public TypRozliczen TypRozliczen
            {
                get { return typRozliczen; }
                set
                {
                    typRozliczen = value;
                    OnChanged();
                }
            }


            [Priority(20)]
            public override FromTo Okres
            {
                get { return base.Okres; }
                set
                {
                    base.Okres = value != FromTo.Empty ? value : FromTo.All;
                    OnChanged();
                }
            }


            [Priority(30)]
            [Caption("Okres księgowy")]
            public FromTo OkresKS
            {
                get { return okresKS; }
                set
                {
                    okresKS = value != FromTo.Empty ? value : FromTo.All;
                    OnChanged();
                }
            }


            [Priority(140)]
            [Caption("Zakres")]
            public Zakres ZakresRaportu
            {
                get { return zakres; }
                set
                {
                    if ((zakres = value) != Zakres.Kontrahenci)
                        wartośćCechy = String.Empty;
                    OnChanged();
                }
            }


            [Priority(150)]
            [Caption("Od kontrahenta")]
            public IPodmiotKasowy Od
            {
                get { return odk; }
                set
                {
                    odk = value;
                    OnChanged();
                }
            }


            [Priority(160)]
            [Caption("Do kontrahenta")]
            public IPodmiotKasowy Do
            {
                get { return dok; }
                set
                {
                    dok = value;
                    OnChanged();
                }
            }


            [Priority(170)]
            [Caption(wgWartościLabel)]
            [Browsable(wgWartościLabel != "")]
            [Dictionary(wgWartościDictionary)]
            public String WartośćCechy
            {
                get { return wartośćCechy; }
                set
                {
                    wartośćCechy = value;
                    OnChanged();
                }
            }


            public Boolean IsReadOnlyWartośćCechy()
            { return wgWartościCechy == "" || zakres != Zakres.Kontrahenci; }


            [Priority(180)]
            [Caption("Dokumenty")]
            public TypDokumentow DokumentyTyp
            {
                get { return dokumenty; }
                set
                {
                    dokumenty = value;
                    OnChanged();
                }
            }


            [Priority(190)]
            [Caption("Rodzaj")]
            public RodzajDokumentów Rodzaj
            {
                get { return rodzaj; }
                set
                {
                    rodzaj = value;
                    OnChanged();
                }
            }


            [Priority(200)]
            [Caption("Wg wartości PLNHist")]
            public Boolean WgWartosciPLNHist
            {
                get { return wgWartosciPLNHist; }
                set
                {
                    wgWartosciPLNHist = value;
                    OnChanged();
                }
            }


            [Priority(210)]
            [Caption("Waluta")]
            public Waluta WalutaRaportu
            {
                get { return waluta; }
                set
                {
                    waluta = value;
                    OnChanged();
                }
            }


            [Priority(220)]
            [Caption("Aktualne konto")]
            public String AktualneKonto
            {
                get { return aktualneKonto; }
                set
                {
                    aktualneKonto = value.ToUpper();
                    OnChanged();
                }
            }
        }


        [Context(Required = true)]
        public PrnParams Params
        {
            get { return pars; }
            set { pars = value; }
        }


        [Context(Required = true)]
        public WydrukOddzialParams OParams { get; set; }


        //
        // WERYFIKATOR WALUTY
        //


        public class WeryfikatorWaluty : Verifier
        {
            readonly PrnParams data;
            bool active = false;

            public WeryfikatorWaluty(PrnParams data)
            { this.data = data; }

            public override VerifierType Type
            { get { return VerifierType.Error; } }

            public override String Description
            { get { return Str_WeryfikatorWaluty; } }

            protected override Boolean IsValid()
            { return data.WalutaRaportu != null || data.WgWartosciPLNHist; }

            public override Object Source
            { get { return this.data; } }

            protected override bool IsAccept(object data, string property, VerifierAction action)
            {
                if (action == VerifierAction.AcceptRow) active = true;
                return active && data == this.data && property == "Waluta";
            }

            public override bool Equals(object v)
            { return GetType() == v.GetType() && data == ((WeryfikatorWaluty)v).data; }

            public override int GetHashCode()
            { return data.GetHashCode(); }
        }


        //
        // LOCAL VARIABLES
        //


        private PrnParams pars = null;
        private WydrukiRozrachunkowFiltr wr = new WydrukiRozrachunkowFiltr();


        //
        // SORTOWACZ PODMIOTOW
        //


        private class ComparePodmiot : IComparer
        {
            public int Compare(Object px, Object py)
            { return ((Podsumowanie)px).Podmiot.Kod.CompareTo(((Podsumowanie)py).Podmiot.Kod); }
        }


        //
        // PODSUMOWANIE (wiersz zestawienia)
        //


        private class Podsumowanie
        {
            private readonly IPodmiotKasowy podmiot;
            private readonly PrnParams prms;

            private Decimal razem;
            private Decimal biezace;
            private Decimal przeterminowane;
            private Decimal[] zaleglosci = new Decimal[okresy.Length + 1];


            public Podsumowanie(IPodmiotKasowy podmiot, PrnParams prms)
            {
                this.podmiot = podmiot;
                this.prms = prms;
            }


            public void Add(RozrachunekIdx idx, StanRozliczeniaRozrachunkuWorker srrWorker)
            {
                int zwłoka;
                Currency kwotaZob;
                Currency kwotaNal;

                if (prms.TypRozliczen == TypRozliczen.Kasowe)
                {
                    zwłoka = idx.ZwłokaNaDzień(prms.Aktualny);

                    kwotaZob = prms.WgWartosciPLNHist ? srrWorker.ZobowiazaniePLNHist(prms.Aktualny) : srrWorker.Zobowiazanie(prms.Aktualny);
                    kwotaNal = prms.WgWartosciPLNHist ? srrWorker.NaleznoscPLNHist(prms.Aktualny) : srrWorker.Naleznosc(prms.Aktualny);
                }
                else
                {
                    zwłoka = idx.ZwłokaKsiNaDzień(prms.Aktualny);

                    kwotaZob = prms.WgWartosciPLNHist ? srrWorker.ZobowiazanieKsi(prms.Aktualny) : srrWorker.ZobowiazanieKsiOpe(prms.Aktualny);
                    kwotaNal = prms.WgWartosciPLNHist ? srrWorker.NaleznoscKsi(prms.Aktualny) : srrWorker.NaleznoscKsiOpe(prms.Aktualny);
                }

                switch (prms.DokumentyTyp)
                {
                    case TypDokumentow.Należności:
                        dodaj(kwotaNal.Value, zwłoka);
                        break;

                    case TypDokumentow.Zobowiązania:
                        dodaj(kwotaZob.Value, zwłoka);
                        break;

                    default:
                        dodaj(kwotaNal.Value - kwotaZob.Value, zwłoka);
                        break;
                }
            }


            private void dodaj(Decimal kwota, int zwloka)
            {
                razem += kwota;

                if (zwloka == 0)
                    biezace += kwota;
                else
                {
                    przeterminowane += kwota;
                    for (int i = 0; i < okresy.Length; i++)
                        if (zwloka <= okresy[i])
                        {
                            zaleglosci[i] += kwota;
                            return;
                        }
                    zaleglosci[okresy.Length] += kwota;
                }
            }


            public IPodmiotKasowy Podmiot
            { get { return podmiot; } }

            public Decimal Razem
            { get { return razem; } }

            public Decimal Biezace
            { get { return biezace; } }

            public Decimal Przeterminowane
            { get { return przeterminowane; } }

            public Decimal[] Zaleglosci
            { get { return zaleglosci; } }
        }


        //
        // USTAWIANIE DANYCH WIERSZA
        //


        protected void Grid1_BeforeRow(object sender, RowEventArgs args)
        {
            Podsumowanie row = (Podsumowanie)args.Row;
            for (int i = 0; i <= okresy.Length; i++)
                Grid1.Columns[6 + i].EditValue = row.Zaleglosci[i];
        }


        //
        // LOAD
        //


        protected void OnContextLoad(object sender, EventArgs e)
        {
            colPrzeterminowane.Visible = razemPrzeterminowane;

            //
            // -> kolumny dynamiczne zgodnie w podziałem stref
            //

            for (int i = 0; i <= okresy.Length; i++)
            {
                GridColumn nowa = new GridColumn();
                Grid1.Columns.Add(nowa);
                if (i == 0)
                    nowa.Caption = Str_PrzeterminowaneOd1Do + okresy[i] + Str_Dni;
                else if (i == okresy.Length)
                    nowa.Caption = Str_PrzeterminowanePonad + okresy[i - 1] + Str_Dni;
                else
                    nowa.Caption = Str_PrzeterminowaneOd + (okresy[i - 1] + 1) + Str_Do + okresy[i] + Str_Dni;

                nowa.Align = HorizontalAlign.Right;
                nowa.Format = "{0:n}";
                nowa.Total = Total.Sum;
                nowa.HideZero = true;
                nowa.Width = 12;
            }


            wr.PodmiotOd = pars.Od;
            wr.PodmiotDo = pars.Do;
            wr.TypRozliczenKsiegowy = pars.TypRozliczen == TypRozliczen.Księgowe;
            wr.Waluta = pars.WalutaRaportu;
            wr.SetAktualneKonto(pars.AktualneKonto, pars.Aktualny);
            wr.SetFeature(wgWartościCechy, pars.WartośćCechy);


            //
            // NAGŁÓWEK RAPORTU
            //

            ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
            ReportHeader1["TYPROZLICZEN"] = pars.TypRozliczen == TypRozliczen.Kasowe ? Str_Kasowych : Str_Ksiegowych;
            ReportHeader1["TYP"] = pars.DokumentyTyp == TypDokumentow.PerSaldo ? Str_PerSaldo : (pars.DokumentyTyp == TypDokumentow.Należności ? Str_Naleznosci : Str_Zobowiazan);
            ReportHeader1["RODZAJ"] = pars.Rodzaj == RodzajDokumentów.Razem ? String.Empty : "|" + Str_Rodzaj + ": <STRONG>" + pars.Rodzaj + "</STRONG>";
            ReportHeader1["ZAKRES"] = pars.ZakresRaportu == Zakres.Razem ? String.Empty : "|" + Str_Zakres + ": <STRONG>" + pars.ZakresRaportu + "</STRONG>";
            ReportHeader1["WGCECHY"] = pars.ZakresRaportu != Zakres.Kontrahenci || pars.WartośćCechy == String.Empty ? String.Empty : String.Format("|</STRONG>{0}: <STRONG> {1}", wgWartościCechy, pars.WartośćCechy);
            ReportHeader1["KONTRAHENT"] = wr.GetTitleStringPodmiot();
            ReportHeader1["KONTO"] = wr.GetTitleStringKonto();
            ReportHeader1["WALUTA"] = wr.GetTitleStringWaluta(pars.WgWartosciPLNHist);

            //
            // QUERY
            //

            KasaModule kasa = KasaModule.GetInstance(dc);
            Soneta.Business.View view = null;

            if (pars.TypRozliczen == TypRozliczen.Kasowe)
            {
                //
                // -> rozliczenia kasowe:
                // - rachunki nierozliczone na dzień aktualności
                // - z odpowiednim okresem wystawienia
                // - z odpowiednim okresem księgowania
                //

                view = kasa.RozrachunkiIdx.Nierozliczone(null, pars.Okres, pars.Aktualny);

                if (pars.OkresKS != FromTo.All)
                    view.Condition &= new FieldCondition.Contain("DataKsiegowania", pars.OkresKS);
            }
            else
            {
                //
                // -> rozliczenia księgowe:
                // - bez ograniczenia na rozliczenie kasowe
                // - odpowiednik wyszukiwania na widoku rozliczeń KS niezaksięgowanych
                //

                view = kasa.RozrachunkiIdx.CreateView();
                view.Condition = new FieldCondition.Contain("DataKsiegowania", pars.OkresKS * new FromTo(Date.MinValid + 1, Date.MaxValid - 1));

                if (pars.Okres != FromTo.All)
                    view.Condition &= new FieldCondition.Contain("Data", pars.Okres);

                view.Condition &= new FieldCondition.Greater("DataOstatniegoKsi", pars.Aktualny) | new FieldCondition.Equal("DataRozliczenia", Date.MaxValue);
            }

            view.Condition &= zakresCondition();
            view.Condition &= rodzajCondition(kasa.RozrachunkiIdx);
            view.Condition &= OParams.GetConditionIdx();

            StanRozliczeniaRozrachunkuWorker workerSrr = new StanRozliczeniaRozrachunkuWorker();
            workerSrr.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;
            workerSrr.StanRozliczeniaKs = StanRozliczeniaRozrachunku.Nierozliczone;

            Dictionary<IPodmiotKasowy, Podsumowanie> dict = new Dictionary<IPodmiotKasowy, Podsumowanie>();

            wr.SetFilter(view);

            foreach (RozrachunekIdx idx in view)
            {
                Podsumowanie pds = null;

                if (dict.ContainsKey(idx.Podmiot))
                    pds = dict[idx.Podmiot];
                else
                {
                    pds = new Podsumowanie(idx.Podmiot, pars);
                    dict.Add(idx.Podmiot, pds);
                }

                workerSrr.RozrachunekIdx = idx;
                pds.Add(idx, workerSrr);
            }

            ArrayList lst = new ArrayList(dict.Values);
            lst.Sort(new ComparePodmiot());

            Grid1.DataSource = lst;
        }


        //
        // FILTRY
        //


        private RowCondition zakresCondition()
        {
            switch (pars.ZakresRaportu)
            {
                case Zakres.Kontrahenci:
                    return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));

                case Zakres.Pracownicy:
                    return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));

                case Zakres.Urzędy:
                    RowCondition condition = RowCondition.Empty;
                    condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
                    condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
                    return new RowCondition.Not(condition);

                default:
                    return RowCondition.Empty;
            }
        }


        private RowCondition rodzajCondition(RozrachunkiIdx idxTable)
        {
            Boolean fNaleznosci = pars.DokumentyTyp != TypDokumentow.Zobowiązania;
            Boolean fZobowiazania = pars.DokumentyTyp != TypDokumentow.Należności;
            Boolean fZaplaty = pars.Rodzaj != RodzajDokumentów.Płatności;
            Boolean fPlatnosci = pars.Rodzaj != RodzajDokumentów.Zapłaty;

            return idxTable.ZakresEx(fNaleznosci && fPlatnosci, fZobowiazania && fPlatnosci, fZobowiazania && fZaplaty, fNaleznosci && fZaplaty);
        }


        //
        // Zarzadzanie kontekstem
        //


        private WydrukiRozrachunkowSessionProxy sProxy = null;


        protected void OnContextLoading(Object sender, EventArgs args)
        {
            sProxy = WydrukiRozrachunkowSessionProxy.GetSingleDbInstance(dc.Context);
            dc.attachContext(sProxy.CloneContext(dc.Context));
        }


        protected override void OnUnload(EventArgs e)
        {
            WydrukiRozrachunkowSessionProxy.SmartDispose(ref sProxy);
            base.OnUnload(e);
        }
    }
}
